const jwt = require('jsonwebtoken');

const JWT_SECRET = process.env.JWT_SECRET || 'dev-secret-change-me';

const generateToken = (user = {}) => {
  // include the fields you want to read on the client/server
  const payload = {
    id: user.id,
    email: user.email,
    name: user.name,
    user_type: user.user_type,
    company_id: user.company_id,
    permissions: user.permissions || null, // optional
  };
  return jwt.sign(payload, JWT_SECRET, { expiresIn: '24h' });
};

const verifyToken = (req, res, next) => {
  const authHeader = req.headers.authorization || '';
  const tokenFromHeader = authHeader.startsWith('Bearer ') ? authHeader.split(' ')[1] : null;
  const token = tokenFromHeader || (req.cookies && req.cookies.token);

  if (!token) {
    return res.status(401).json({ success: false, message: 'No token provided' });
  }

  try {
    const decoded = jwt.verify(token, JWT_SECRET);
    // attach full decoded payload (id, email, name, user_type, company_id, permissions)
    req.user = decoded;
    next();
  } catch (err) {
    return res.status(401).json({ success: false, message: 'Invalid or expired token' });
  }
};

module.exports = { generateToken, verifyToken };